
#include "fp.h"
#include "matfp.hpp"
#include "matfpMath.hpp"
#include "matfpConv.hpp"
#include "matq.h"
#include "matqConv.h"
#include "matqMath.h"
#include "bf.h"
#include "matc.hpp"
#include "matcConv.hpp"
#include "matcMath.hpp"
#include "poly.h"
#include "polyConv.h"
#include "polyMath.h"
#include "polyFactor.h"
#include "mbMod.h"

using namespace std;

// https://en.wikipedia.org/wiki/Factorization_of_polynomials_over_finite_fields#Square-free_factorization

int main (int argc, char * const argv[])
{
    poly    f, temp;
    poly    *factors;
    int     i, *power, numPolys, len;
    char    *xString, *outString;
    string  inString;
    
again:
    cout << "poly: ";
    getline(cin, inString);
    cout << endl;
    
    len = strlen(inString.c_str());
    xString = (char*)malloc((len+1)*sizeof(char));
    strcpy(xString, inString.c_str());
    
    if(!polyConvFromxString(f, xString))
    {
        cout << "bad input" << endl << endl;
        goto again;
    }
    
    if(f.array[f.deg]!=1)
    {
        cout << "The polynomial is not monic." << endl << endl;
        goto again;
    }
    
    if(f.deg==0)
    {
        cout << f.array[0].num << endl << endl;
        goto again;
    }
    
    findPowersOfSquareFreeFactors(factors, power, numPolys, f);
    
    for(i=0;i<numPolys;++i)
    {
        temp = factors[i];
        polyConvToxString(outString, temp);
        if(power[i]==1)
            cout << outString << endl;
        else
        {
            if(!(temp.deg==1 && temp.array[0]==0))
                cout << "(" << outString << ")^" << power[i] << endl;
            else
                cout << outString << "^" << power[i] << endl;
        }
        free(outString);
    }
    cout << endl;
    
    
    
    return 0;
}

// findPowersOfSquareFreeFactors(poly*& z1, int*& theExp, int& numPolys, const poly& x)
 /*
 clock_t start, end;
 double elapsed;
 
 start = clock();

end = clock();
elapsed = ((double) (end - start)) / CLOCKS_PER_SEC;
 */
